clear all
clc
close all

load AALabData

Y=Action;
features=FeaturesAct;
featGame=FeaturesMatrix;
n=length(Y);

%% Pareto Dominant Nash

ind=[3,15,27];

FeatParetoDomNE=features(:,ind);

paretonepred=zeros(n,1);
for i=1:n
    if sum(FeatParetoDomNE(i,:))>0
        paretonepred(i)=find(FeatParetoDomNE(i,:));
    else
        paretonepred(i)=8;
    end       
end

%% Evaluate

testalpha=0.01:0.05:2;
r=length(testalpha);

Q=25;
accurate=zeros(Q,1);
acc=zeros(1,Q);
for q=1:Q
    K=10;
    c = cvpartition(n,'KFold',K);
    for k=1:K
        
        % Training Data
        
        train=find(c.training(k));
        trainPNE=paretonepred(train);
        trainY=Y(train,:);
        trainRow=row(train);
        
        Acc=zeros(1,r);
        m=length(train);
        for i=1:r
            alpha=testalpha(i);
            lev1R=zeros(1,m);
            accurate=zeros(1,m);
            for h=1:m
                R=trainRow{h}.^alpha;
                [~,lev1R(h)]=max(sum(R,2));
                accurate(h)=logical(trainY(h)==lev1R(h));
            end
            Acc(i)=mean(accurate);
            clear lev1R accurate
        end
        [~,best]=max(Acc);
        bestalpha(k)=testalpha(best);       
        
        trainlev1=zeros(m,1);
        for i=1:m
             R=trainRow{i}.^bestalpha(k);
             [~,trainlev1(i)]=max(sum(R,2));
        end
        
        trainNew=featGame(train,:);
        
        errpne{k}=double(logical(trainPNE~=trainY));
        errlev1{k}=double((logical(trainY~=trainlev1)));
        
        treemodelpne{k}=fitrtree(trainNew,errpne{k},'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
        treemodellev1{k}=fitrtree(trainNew,errlev1{k},'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
        
        % Test Data
        
        test=find(c.test(k));
        testY{k}=Y(test,:);
        testRow=row(test);
        testNew=featGame(test,:);
        
        pnepredicttest=paretonepred(test);
        
        s=length(test);
        testlev1=zeros(s,1);
        for i=1:s
             R=testRow{i}.^bestalpha(k);
             [~,testlev1(i)]=max(sum(R,2));
        end
        
        predictpneerr{k}=predict(treemodelpne{k},testNew);
        predictlev1err{k}=predict(treemodellev1{k},testNew);
        
        m=length(testY{k});
        for j=1:m
            if predictpneerr{k}(j)<predictlev1err{k}(j)
                prediction{k}(j)=pnepredicttest(j);
            else
                prediction{k}(j)=testlev1(j);
            end
        end
        error(k)=length(find(prediction{k}'~=testY{k}))/length(prediction{k});
    end    
    acc(q)=1-mean(error);    
end

'Accuracy'
mean(acc)

'Standard Error'
sqrt(var(error))/sqrt(K)
